/*
 * Decompiled with CFR 0.152.
 */
package edu.wpi.first.wpilibj;

import edu.wpi.first.wpilibj.Counter;
import edu.wpi.first.wpilibj.CounterBase;
import edu.wpi.first.wpilibj.DigitalInput;
import edu.wpi.first.wpilibj.DigitalSource;
import edu.wpi.first.wpilibj.PIDSource;
import edu.wpi.first.wpilibj.PIDSourceType;
import edu.wpi.first.wpilibj.SensorBase;
import edu.wpi.first.wpilibj.communication.UsageReporting;
import edu.wpi.first.wpilibj.hal.EncoderJNI;
import edu.wpi.first.wpilibj.livewindow.LiveWindow;
import edu.wpi.first.wpilibj.livewindow.LiveWindowSendable;
import edu.wpi.first.wpilibj.tables.ITable;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;

public class Encoder
extends SensorBase
implements CounterBase,
PIDSource,
LiveWindowSendable {
    protected DigitalSource m_aSource;
    protected DigitalSource m_bSource;
    protected DigitalSource m_indexSource = null;
    private long m_encoder;
    private int m_index;
    private double m_distancePerPulse;
    private Counter m_counter;
    private CounterBase.EncodingType m_encodingType = CounterBase.EncodingType.k4X;
    private int m_encodingScale;
    private boolean m_allocatedA;
    private boolean m_allocatedB;
    private boolean m_allocatedI;
    private PIDSourceType m_pidSource;
    private ITable m_table;

    private void initEncoder(boolean reverseDirection) {
        switch (this.m_encodingType) {
            case k4X: {
                this.m_encodingScale = 4;
                ByteBuffer index = ByteBuffer.allocateDirect(4);
                index.order(ByteOrder.LITTLE_ENDIAN);
                this.m_encoder = EncoderJNI.initializeEncoder(this.m_aSource.getModuleForRouting(), this.m_aSource.getChannelForRouting(), this.m_aSource.getAnalogTriggerForRouting(), this.m_bSource.getModuleForRouting(), this.m_bSource.getChannelForRouting(), this.m_bSource.getAnalogTriggerForRouting(), reverseDirection, index.asIntBuffer());
                this.m_index = index.asIntBuffer().get(0);
                this.m_counter = null;
                this.setMaxPeriod(0.5);
                break;
            }
            case k2X: 
            case k1X: {
                this.m_encodingScale = this.m_encodingType == CounterBase.EncodingType.k1X ? 1 : 2;
                this.m_counter = new Counter(this.m_encodingType, this.m_aSource, this.m_bSource, reverseDirection);
                this.m_index = this.m_counter.getFPGAIndex();
            }
        }
        this.m_distancePerPulse = 1.0;
        this.m_pidSource = PIDSourceType.kDisplacement;
        UsageReporting.report(18, this.m_index, this.m_encodingType.value);
        LiveWindow.addSensor("Encoder", this.m_aSource.getChannelForRouting(), (LiveWindowSendable)this);
    }

    public Encoder(int aChannel, int bChannel, boolean reverseDirection) {
        this.m_allocatedA = true;
        this.m_allocatedB = true;
        this.m_allocatedI = false;
        this.m_aSource = new DigitalInput(aChannel);
        this.m_bSource = new DigitalInput(bChannel);
        this.initEncoder(reverseDirection);
    }

    public Encoder(int aChannel, int bChannel) {
        this(aChannel, bChannel, false);
    }

    public Encoder(int aChannel, int bChannel, boolean reverseDirection, CounterBase.EncodingType encodingType) {
        this.m_allocatedA = true;
        this.m_allocatedB = true;
        this.m_allocatedI = false;
        if (encodingType == null) {
            throw new NullPointerException("Given encoding type was null");
        }
        this.m_encodingType = encodingType;
        this.m_aSource = new DigitalInput(aChannel);
        this.m_bSource = new DigitalInput(bChannel);
        this.initEncoder(reverseDirection);
    }

    public Encoder(int aChannel, int bChannel, int indexChannel, boolean reverseDirection) {
        this.m_allocatedA = true;
        this.m_allocatedB = true;
        this.m_allocatedI = true;
        this.m_aSource = new DigitalInput(aChannel);
        this.m_bSource = new DigitalInput(bChannel);
        this.m_indexSource = new DigitalInput(indexChannel);
        this.initEncoder(reverseDirection);
        this.setIndexSource(indexChannel);
    }

    public Encoder(int aChannel, int bChannel, int indexChannel) {
        this(aChannel, bChannel, indexChannel, false);
    }

    public Encoder(DigitalSource aSource, DigitalSource bSource, boolean reverseDirection) {
        this.m_allocatedA = false;
        this.m_allocatedB = false;
        this.m_allocatedI = false;
        if (aSource == null) {
            throw new NullPointerException("Digital Source A was null");
        }
        this.m_aSource = aSource;
        if (bSource == null) {
            throw new NullPointerException("Digital Source B was null");
        }
        this.m_bSource = bSource;
        this.initEncoder(reverseDirection);
    }

    public Encoder(DigitalSource aSource, DigitalSource bSource) {
        this(aSource, bSource, false);
    }

    public Encoder(DigitalSource aSource, DigitalSource bSource, boolean reverseDirection, CounterBase.EncodingType encodingType) {
        this.m_allocatedA = false;
        this.m_allocatedB = false;
        this.m_allocatedI = false;
        if (encodingType == null) {
            throw new NullPointerException("Given encoding type was null");
        }
        this.m_encodingType = encodingType;
        if (aSource == null) {
            throw new NullPointerException("Digital Source A was null");
        }
        this.m_aSource = aSource;
        if (bSource == null) {
            throw new NullPointerException("Digital Source B was null");
        }
        this.m_aSource = aSource;
        this.m_bSource = bSource;
        this.initEncoder(reverseDirection);
    }

    public Encoder(DigitalSource aSource, DigitalSource bSource, DigitalSource indexSource, boolean reverseDirection) {
        this.m_allocatedA = false;
        this.m_allocatedB = false;
        this.m_allocatedI = false;
        if (aSource == null) {
            throw new NullPointerException("Digital Source A was null");
        }
        this.m_aSource = aSource;
        if (bSource == null) {
            throw new NullPointerException("Digital Source B was null");
        }
        this.m_aSource = aSource;
        this.m_bSource = bSource;
        this.m_indexSource = indexSource;
        this.initEncoder(reverseDirection);
        this.setIndexSource(indexSource);
    }

    public Encoder(DigitalSource aSource, DigitalSource bSource, DigitalSource indexSource) {
        this(aSource, bSource, indexSource, false);
    }

    public int getFPGAIndex() {
        return this.m_index;
    }

    public int getEncodingScale() {
        return this.m_encodingScale;
    }

    @Override
    public void free() {
        if (this.m_aSource != null && this.m_allocatedA) {
            this.m_aSource.free();
            this.m_allocatedA = false;
        }
        if (this.m_bSource != null && this.m_allocatedB) {
            this.m_bSource.free();
            this.m_allocatedB = false;
        }
        if (this.m_indexSource != null && this.m_allocatedI) {
            this.m_indexSource.free();
            this.m_allocatedI = false;
        }
        this.m_aSource = null;
        this.m_bSource = null;
        this.m_indexSource = null;
        if (this.m_counter != null) {
            this.m_counter.free();
            this.m_counter = null;
        } else {
            EncoderJNI.freeEncoder(this.m_encoder);
        }
    }

    public int getRaw() {
        int value = this.m_counter != null ? this.m_counter.get() : EncoderJNI.getEncoder(this.m_encoder);
        return value;
    }

    @Override
    public int get() {
        return (int)((double)this.getRaw() * this.decodingScaleFactor());
    }

    @Override
    public void reset() {
        if (this.m_counter != null) {
            this.m_counter.reset();
        } else {
            EncoderJNI.resetEncoder(this.m_encoder);
        }
    }

    @Override
    public double getPeriod() {
        double measuredPeriod = this.m_counter != null ? this.m_counter.getPeriod() / this.decodingScaleFactor() : EncoderJNI.getEncoderPeriod(this.m_encoder);
        return measuredPeriod;
    }

    @Override
    public void setMaxPeriod(double maxPeriod) {
        if (this.m_counter != null) {
            this.m_counter.setMaxPeriod(maxPeriod * this.decodingScaleFactor());
        } else {
            EncoderJNI.setEncoderMaxPeriod(this.m_encoder, maxPeriod);
        }
    }

    @Override
    public boolean getStopped() {
        if (this.m_counter != null) {
            return this.m_counter.getStopped();
        }
        return EncoderJNI.getEncoderStopped(this.m_encoder);
    }

    @Override
    public boolean getDirection() {
        if (this.m_counter != null) {
            return this.m_counter.getDirection();
        }
        return EncoderJNI.getEncoderDirection(this.m_encoder);
    }

    private double decodingScaleFactor() {
        switch (this.m_encodingType) {
            case k1X: {
                return 1.0;
            }
            case k2X: {
                return 0.5;
            }
            case k4X: {
                return 0.25;
            }
        }
        return 0.0;
    }

    public double getDistance() {
        return (double)this.getRaw() * this.decodingScaleFactor() * this.m_distancePerPulse;
    }

    public double getRate() {
        return this.m_distancePerPulse / this.getPeriod();
    }

    public void setMinRate(double minRate) {
        this.setMaxPeriod(this.m_distancePerPulse / minRate);
    }

    public void setDistancePerPulse(double distancePerPulse) {
        this.m_distancePerPulse = distancePerPulse;
    }

    public void setReverseDirection(boolean reverseDirection) {
        if (this.m_counter != null) {
            this.m_counter.setReverseDirection(reverseDirection);
        }
    }

    public void setSamplesToAverage(int samplesToAverage) {
        switch (this.m_encodingType) {
            case k4X: {
                EncoderJNI.setEncoderSamplesToAverage(this.m_encoder, samplesToAverage);
                break;
            }
            case k2X: 
            case k1X: {
                this.m_counter.setSamplesToAverage(samplesToAverage);
            }
        }
    }

    public int getSamplesToAverage() {
        switch (this.m_encodingType) {
            case k4X: {
                return EncoderJNI.getEncoderSamplesToAverage(this.m_encoder);
            }
            case k2X: 
            case k1X: {
                return this.m_counter.getSamplesToAverage();
            }
        }
        return 1;
    }

    @Override
    public void setPIDSourceType(PIDSourceType pidSource) {
        this.m_pidSource = pidSource;
    }

    @Override
    public PIDSourceType getPIDSourceType() {
        return this.m_pidSource;
    }

    @Override
    public double pidGet() {
        switch (this.m_pidSource) {
            case kDisplacement: {
                return this.getDistance();
            }
            case kRate: {
                return this.getRate();
            }
        }
        return 0.0;
    }

    public void setIndexSource(int channel, IndexingType type) {
        boolean activeHigh = type == IndexingType.kResetWhileHigh || type == IndexingType.kResetOnRisingEdge;
        boolean edgeSensitive = type == IndexingType.kResetOnFallingEdge || type == IndexingType.kResetOnRisingEdge;
        EncoderJNI.setEncoderIndexSource(this.m_encoder, channel, false, activeHigh, edgeSensitive);
    }

    public void setIndexSource(int channel) {
        this.setIndexSource(channel, IndexingType.kResetOnRisingEdge);
    }

    public void setIndexSource(DigitalSource source, IndexingType type) {
        boolean activeHigh = type == IndexingType.kResetWhileHigh || type == IndexingType.kResetOnRisingEdge;
        boolean edgeSensitive = type == IndexingType.kResetOnFallingEdge || type == IndexingType.kResetOnRisingEdge;
        EncoderJNI.setEncoderIndexSource(this.m_encoder, source.getChannelForRouting(), source.getAnalogTriggerForRouting(), activeHigh, edgeSensitive);
    }

    public void setIndexSource(DigitalSource source) {
        this.setIndexSource(source, IndexingType.kResetOnRisingEdge);
    }

    @Override
    public String getSmartDashboardType() {
        switch (this.m_encodingType) {
            case k4X: {
                return "Quadrature Encoder";
            }
        }
        return "Encoder";
    }

    @Override
    public void initTable(ITable subtable) {
        this.m_table = subtable;
        this.updateTable();
    }

    @Override
    public ITable getTable() {
        return this.m_table;
    }

    @Override
    public void updateTable() {
        if (this.m_table != null) {
            this.m_table.putNumber("Speed", this.getRate());
            this.m_table.putNumber("Distance", this.getDistance());
            this.m_table.putNumber("Distance per Tick", this.m_distancePerPulse);
        }
    }

    @Override
    public void startLiveWindowMode() {
    }

    @Override
    public void stopLiveWindowMode() {
    }

    public static enum IndexingType {
        kResetWhileHigh,
        kResetWhileLow,
        kResetOnFallingEdge,
        kResetOnRisingEdge;

    }
}

