/*
 * Decompiled with CFR 0.152.
 */
package edu.wpi.first.wpilibj;

import edu.wpi.first.wpilibj.InterruptableSensorBase;
import edu.wpi.first.wpilibj.Resource;
import edu.wpi.first.wpilibj.hal.DIOJNI;
import edu.wpi.first.wpilibj.util.AllocationException;
import edu.wpi.first.wpilibj.util.CheckedAllocationException;

public abstract class DigitalSource
extends InterruptableSensorBase {
    protected static Resource channels = new Resource(26);
    protected long m_port;
    protected int m_channel;

    protected void initDigitalPort(int channel, boolean input) {
        this.m_channel = channel;
        DigitalSource.checkDigitalChannel(this.m_channel);
        try {
            channels.allocate(this.m_channel);
        }
        catch (CheckedAllocationException ex) {
            throw new AllocationException("Digital input " + this.m_channel + " is already allocated");
        }
        long port_pointer = DIOJNI.getPort((byte)channel);
        this.m_port = DIOJNI.initializeDigitalPort(port_pointer);
        DIOJNI.allocateDIO(this.m_port, input);
    }

    @Override
    public void free() {
        channels.free(this.m_channel);
        DIOJNI.freeDIO(this.m_port);
        DIOJNI.freeDigitalPort(this.m_port);
        this.m_port = 0L;
        this.m_channel = 0;
    }

    @Override
    public int getChannelForRouting() {
        return this.m_channel;
    }

    @Override
    public byte getModuleForRouting() {
        return 0;
    }

    @Override
    public boolean getAnalogTriggerForRouting() {
        return false;
    }
}

