/*
 * Decompiled with CFR 0.152.
 */
package edu.wpi.first.wpilibj;

import edu.wpi.first.wpilibj.DigitalSource;
import edu.wpi.first.wpilibj.communication.UsageReporting;
import edu.wpi.first.wpilibj.hal.DIOJNI;
import edu.wpi.first.wpilibj.hal.PWMJNI;
import edu.wpi.first.wpilibj.livewindow.LiveWindowSendable;
import edu.wpi.first.wpilibj.tables.ITable;
import edu.wpi.first.wpilibj.tables.ITableListener;

public class DigitalOutput
extends DigitalSource
implements LiveWindowSendable {
    private static final long invalidPwmGenerator = -1L;
    private long m_pwmGenerator = -1L;
    private ITable m_table;
    private ITableListener m_table_listener;

    public DigitalOutput(int channel) {
        this.initDigitalPort(channel, false);
        UsageReporting.report(14, channel);
    }

    @Override
    public void free() {
        if (this.m_pwmGenerator != -1L) {
            this.disablePWM();
        }
        super.free();
    }

    public void set(boolean value) {
        DIOJNI.setDIO(this.m_port, (short)(value ? 1 : 0));
    }

    public int getChannel() {
        return this.m_channel;
    }

    public void pulse(int channel, float pulseLength) {
        DIOJNI.pulse(this.m_port, pulseLength);
    }

    @Deprecated
    public void pulse(int channel, int pulseLength) {
        float convertedPulse = (float)((double)pulseLength / 1.0E9 * (double)(DIOJNI.getLoopTiming() * 25));
        System.err.println("You should use the float version of pulse for portability.  This is deprecated");
        DIOJNI.pulse(this.m_port, convertedPulse);
    }

    public boolean isPulsing() {
        return DIOJNI.isPulsing(this.m_port);
    }

    public void setPWMRate(double rate) {
        PWMJNI.setPWMRate(rate);
    }

    public void enablePWM(double initialDutyCycle) {
        if (this.m_pwmGenerator != -1L) {
            return;
        }
        this.m_pwmGenerator = PWMJNI.allocatePWM();
        PWMJNI.setPWMDutyCycle(this.m_pwmGenerator, initialDutyCycle);
        PWMJNI.setPWMOutputChannel(this.m_pwmGenerator, this.m_channel);
    }

    public void disablePWM() {
        if (this.m_pwmGenerator == -1L) {
            return;
        }
        PWMJNI.setPWMOutputChannel(this.m_pwmGenerator, 26);
        PWMJNI.freePWM(this.m_pwmGenerator);
        this.m_pwmGenerator = 0L;
    }

    public void updateDutyCycle(double dutyCycle) {
        if (this.m_pwmGenerator == -1L) {
            return;
        }
        PWMJNI.setPWMDutyCycle(this.m_pwmGenerator, dutyCycle);
    }

    @Override
    public String getSmartDashboardType() {
        return "Digital Output";
    }

    @Override
    public void initTable(ITable subtable) {
        this.m_table = subtable;
        this.updateTable();
    }

    @Override
    public ITable getTable() {
        return this.m_table;
    }

    @Override
    public void updateTable() {
    }

    @Override
    public void startLiveWindowMode() {
        this.m_table_listener = new ITableListener(){

            @Override
            public void valueChanged(ITable itable, String key, Object value, boolean bln) {
                DigitalOutput.this.set((Boolean)value);
            }
        };
        this.m_table.addTableListener("Value", this.m_table_listener, true);
    }

    @Override
    public void stopLiveWindowMode() {
        this.m_table.removeTableListener(this.m_table_listener);
    }
}

