/*
 * Decompiled with CFR 0.152.
 */
package edu.wpi.first.wpilibj;

import edu.wpi.first.wpilibj.DigitalSource;
import edu.wpi.first.wpilibj.communication.UsageReporting;
import edu.wpi.first.wpilibj.hal.DIOJNI;
import edu.wpi.first.wpilibj.livewindow.LiveWindow;
import edu.wpi.first.wpilibj.livewindow.LiveWindowSendable;
import edu.wpi.first.wpilibj.tables.ITable;

public class DigitalInput
extends DigitalSource
implements LiveWindowSendable {
    private ITable m_table;

    public DigitalInput(int channel) {
        this.initDigitalPort(channel, true);
        LiveWindow.addSensor("DigitalInput", channel, (LiveWindowSendable)this);
        UsageReporting.report(13, channel);
    }

    public boolean get() {
        return DIOJNI.getDIO(this.m_port);
    }

    public int getChannel() {
        return this.m_channel;
    }

    @Override
    public boolean getAnalogTriggerForRouting() {
        return false;
    }

    @Override
    public String getSmartDashboardType() {
        return "Digital Input";
    }

    @Override
    public void initTable(ITable subtable) {
        this.m_table = subtable;
        this.updateTable();
    }

    @Override
    public void updateTable() {
        if (this.m_table != null) {
            this.m_table.putBoolean("Value", this.get());
        }
    }

    @Override
    public ITable getTable() {
        return this.m_table;
    }

    @Override
    public void startLiveWindowMode() {
    }

    @Override
    public void stopLiveWindowMode() {
    }
}

