/*
 * Decompiled with CFR 0.152.
 */
package edu.wpi.first.wpilibj;

import edu.wpi.first.wpilibj.SensorBase;
import edu.wpi.first.wpilibj.hal.CompressorJNI;
import edu.wpi.first.wpilibj.livewindow.LiveWindowSendable;
import edu.wpi.first.wpilibj.tables.ITable;

public class Compressor
extends SensorBase
implements LiveWindowSendable {
    private long m_pcm;
    private ITable m_table;

    public Compressor(int pcmId) {
        this.initCompressor(pcmId);
    }

    public Compressor() {
        this.initCompressor(Compressor.getDefaultSolenoidModule());
    }

    private void initCompressor(int module) {
        this.m_table = null;
        this.m_pcm = CompressorJNI.initializeCompressor((byte)module);
    }

    public void start() {
        this.setClosedLoopControl(true);
    }

    public void stop() {
        this.setClosedLoopControl(false);
    }

    public boolean enabled() {
        return CompressorJNI.getCompressor(this.m_pcm);
    }

    public boolean getPressureSwitchValue() {
        return CompressorJNI.getPressureSwitch(this.m_pcm);
    }

    public float getCompressorCurrent() {
        return CompressorJNI.getCompressorCurrent(this.m_pcm);
    }

    public void setClosedLoopControl(boolean on) {
        CompressorJNI.setClosedLoopControl(this.m_pcm, on);
    }

    public boolean getClosedLoopControl() {
        return CompressorJNI.getClosedLoopControl(this.m_pcm);
    }

    public boolean getCompressorCurrentTooHighFault() {
        return CompressorJNI.getCompressorCurrentTooHighFault(this.m_pcm);
    }

    public boolean getCompressorCurrentTooHighStickyFault() {
        return CompressorJNI.getCompressorCurrentTooHighStickyFault(this.m_pcm);
    }

    public boolean getCompressorShortedStickyFault() {
        return CompressorJNI.getCompressorShortedStickyFault(this.m_pcm);
    }

    public boolean getCompressorShortedFault() {
        return CompressorJNI.getCompressorShortedFault(this.m_pcm);
    }

    public boolean getCompressorNotConnectedStickyFault() {
        return CompressorJNI.getCompressorNotConnectedStickyFault(this.m_pcm);
    }

    public boolean getCompressorNotConnectedFault() {
        return CompressorJNI.getCompressorNotConnectedFault(this.m_pcm);
    }

    public void clearAllPCMStickyFaults() {
        CompressorJNI.clearAllPCMStickyFaults(this.m_pcm);
    }

    @Override
    public void startLiveWindowMode() {
    }

    @Override
    public void stopLiveWindowMode() {
    }

    @Override
    public String getSmartDashboardType() {
        return "Compressor";
    }

    @Override
    public void initTable(ITable subtable) {
        this.m_table = subtable;
        this.updateTable();
    }

    @Override
    public ITable getTable() {
        return this.m_table;
    }

    @Override
    public void updateTable() {
        if (this.m_table != null) {
            this.m_table.putBoolean("Enabled", this.enabled());
            this.m_table.putBoolean("Pressure Switch", this.getPressureSwitchValue());
        }
    }
}

