/*
 * Decompiled with CFR 0.152.
 */
package edu.wpi.first.wpilibj;

import edu.wpi.first.wpilibj.CANSpeedController;
import edu.wpi.first.wpilibj.MotorSafety;
import edu.wpi.first.wpilibj.MotorSafetyHelper;
import edu.wpi.first.wpilibj.PIDOutput;
import edu.wpi.first.wpilibj.PIDSource;
import edu.wpi.first.wpilibj.PIDSourceType;
import edu.wpi.first.wpilibj.Timer;
import edu.wpi.first.wpilibj.communication.UsageReporting;
import edu.wpi.first.wpilibj.hal.CanTalonJNI;
import edu.wpi.first.wpilibj.livewindow.LiveWindow;
import edu.wpi.first.wpilibj.livewindow.LiveWindowSendable;
import edu.wpi.first.wpilibj.tables.ITable;
import edu.wpi.first.wpilibj.tables.ITableListener;

public class CANTalon
implements MotorSafety,
PIDOutput,
PIDSource,
CANSpeedController {
    private MotorSafetyHelper m_safetyHelper;
    private boolean isInverted = false;
    protected PIDSourceType m_pidSource = PIDSourceType.kDisplacement;
    private final int kNativeAdcUnitsPerRotation = 1024;
    private final double kNativePwdUnitsPerRotation = 4096.0;
    private final double kMinutesPer100msUnit = 0.0016666666666666668;
    private long m_handle;
    private TalonControlMode m_controlMode;
    private static double kDelayForSolicitedSignals = 0.004;
    private double m_minimumInput;
    private double m_maximumInput;
    int m_deviceNumber;
    boolean m_controlEnabled;
    int m_profile;
    double m_setPoint;
    int m_codesPerRev;
    int m_numPotTurns;
    FeedbackDevice m_feedbackDevice;
    private ITable m_table = null;
    private ITableListener m_table_listener = null;

    public CANTalon(int deviceNumber) {
        this.m_deviceNumber = deviceNumber;
        this.m_handle = CanTalonJNI.new_CanTalonSRX(deviceNumber);
        this.m_safetyHelper = new MotorSafetyHelper(this);
        this.m_controlEnabled = true;
        this.m_profile = 0;
        this.m_setPoint = 0.0;
        this.m_codesPerRev = 0;
        this.m_numPotTurns = 0;
        this.m_feedbackDevice = FeedbackDevice.QuadEncoder;
        this.setProfile(this.m_profile);
        this.applyControlMode(TalonControlMode.PercentVbus);
        LiveWindow.addActuator("CANTalon", this.m_deviceNumber, (LiveWindowSendable)this);
    }

    public CANTalon(int deviceNumber, int controlPeriodMs) {
        this.m_deviceNumber = deviceNumber;
        this.m_handle = CanTalonJNI.new_CanTalonSRX(deviceNumber, controlPeriodMs);
        this.m_safetyHelper = new MotorSafetyHelper(this);
        this.m_controlEnabled = true;
        this.m_profile = 0;
        this.m_setPoint = 0.0;
        this.m_codesPerRev = 0;
        this.m_numPotTurns = 0;
        this.m_feedbackDevice = FeedbackDevice.QuadEncoder;
        this.setProfile(this.m_profile);
        this.applyControlMode(TalonControlMode.PercentVbus);
        LiveWindow.addActuator("CANTalon", this.m_deviceNumber, (LiveWindowSendable)this);
    }

    public CANTalon(int deviceNumber, int controlPeriodMs, int enablePeriodMs) {
        this.m_deviceNumber = deviceNumber;
        this.m_handle = CanTalonJNI.new_CanTalonSRX(deviceNumber, controlPeriodMs, enablePeriodMs);
        this.m_safetyHelper = new MotorSafetyHelper(this);
        this.m_controlEnabled = true;
        this.m_profile = 0;
        this.m_setPoint = 0.0;
        this.m_codesPerRev = 0;
        this.m_numPotTurns = 0;
        this.m_feedbackDevice = FeedbackDevice.QuadEncoder;
        this.setProfile(this.m_profile);
        this.applyControlMode(TalonControlMode.PercentVbus);
        LiveWindow.addActuator("CANTalon", this.m_deviceNumber, (LiveWindowSendable)this);
    }

    @Override
    public void pidWrite(double output) {
        if (this.getControlMode() != TalonControlMode.PercentVbus) {
            throw new IllegalStateException("PID only supported in PercentVbus mode");
        }
        this.set(output);
    }

    @Override
    public void setPIDSourceType(PIDSourceType pidSource) {
        this.m_pidSource = pidSource;
    }

    @Override
    public PIDSourceType getPIDSourceType() {
        return this.m_pidSource;
    }

    @Override
    public double pidGet() {
        return this.getPosition();
    }

    public void delete() {
        this.disable();
        if (this.m_handle != 0L) {
            CanTalonJNI.delete_CanTalonSRX(this.m_handle);
            this.m_handle = 0L;
        }
    }

    @Override
    public void set(double outputValue) {
        this.m_safetyHelper.feed();
        if (this.m_controlEnabled) {
            this.m_setPoint = outputValue;
            switch (this.m_controlMode) {
                case PercentVbus: {
                    CanTalonJNI.Set(this.m_handle, this.isInverted ? -outputValue : outputValue);
                    break;
                }
                case Follower: {
                    CanTalonJNI.SetDemand(this.m_handle, (int)outputValue);
                    break;
                }
                case Voltage: {
                    int volts = (int)((this.isInverted ? -outputValue : outputValue) * 256.0);
                    CanTalonJNI.SetDemand(this.m_handle, volts);
                    break;
                }
                case Speed: {
                    CanTalonJNI.SetDemand(this.m_handle, this.ScaleVelocityToNativeUnits(this.m_feedbackDevice, this.isInverted ? -outputValue : outputValue));
                    break;
                }
                case Position: {
                    CanTalonJNI.SetDemand(this.m_handle, this.ScaleRotationsToNativeUnits(this.m_feedbackDevice, outputValue));
                    break;
                }
                case Current: {
                    double milliamperes = (this.isInverted ? -outputValue : outputValue) * 1000.0;
                    CanTalonJNI.SetDemand(this.m_handle, (int)milliamperes);
                    break;
                }
                case MotionProfile: {
                    CanTalonJNI.SetDemand(this.m_handle, (int)outputValue);
                    break;
                }
            }
            CanTalonJNI.SetModeSelect(this.m_handle, this.m_controlMode.value);
        }
    }

    @Override
    public void setInverted(boolean isInverted) {
        this.isInverted = isInverted;
    }

    @Override
    public boolean getInverted() {
        return this.isInverted;
    }

    @Override
    public void set(double outputValue, byte thisValueDoesNotDoAnything) {
        this.set(outputValue);
    }

    @Override
    public void reset() {
        this.disable();
        this.clearIAccum();
    }

    @Override
    public boolean isEnabled() {
        return this.isControlEnabled();
    }

    @Override
    public double getError() {
        return this.getClosedLoopError();
    }

    @Override
    public void setSetpoint(double setpoint) {
        this.set(setpoint);
    }

    public void reverseSensor(boolean flip) {
        CanTalonJNI.SetRevFeedbackSensor(this.m_handle, flip ? 1 : 0);
    }

    public void reverseOutput(boolean flip) {
        CanTalonJNI.SetRevMotDuringCloseLoopEn(this.m_handle, flip ? 1 : 0);
    }

    @Override
    public double get() {
        switch (this.m_controlMode) {
            case Voltage: {
                return this.getOutputVoltage();
            }
            case Current: {
                return this.getOutputCurrent();
            }
            case Speed: {
                return this.ScaleNativeUnitsToRpm(this.m_feedbackDevice, CanTalonJNI.GetSensorVelocity(this.m_handle));
            }
            case Position: {
                return this.ScaleNativeUnitsToRotations(this.m_feedbackDevice, CanTalonJNI.GetSensorPosition(this.m_handle));
            }
        }
        return (double)CanTalonJNI.GetAppliedThrottle(this.m_handle) / 1023.0;
    }

    public int getEncPosition() {
        return CanTalonJNI.GetEncPosition(this.m_handle);
    }

    public void setEncPosition(int newPosition) {
        this.setParameter(CanTalonJNI.param_t.eEncPosition, newPosition);
    }

    public int getEncVelocity() {
        return CanTalonJNI.GetEncVel(this.m_handle);
    }

    public int getPulseWidthPosition() {
        return CanTalonJNI.GetPulseWidthPosition(this.m_handle);
    }

    public void setPulseWidthPosition(int newPosition) {
        this.setParameter(CanTalonJNI.param_t.ePwdPosition, newPosition);
    }

    public int getPulseWidthVelocity() {
        return CanTalonJNI.GetPulseWidthVelocity(this.m_handle);
    }

    public int getPulseWidthRiseToFallUs() {
        return CanTalonJNI.GetPulseWidthRiseToFallUs(this.m_handle);
    }

    public int getPulseWidthRiseToRiseUs() {
        return CanTalonJNI.GetPulseWidthRiseToRiseUs(this.m_handle);
    }

    public FeedbackDeviceStatus isSensorPresent(FeedbackDevice feedbackDevice) {
        FeedbackDeviceStatus retval = FeedbackDeviceStatus.FeedbackStatusUnknown;
        switch (feedbackDevice) {
            case QuadEncoder: 
            case AnalogPot: 
            case AnalogEncoder: 
            case EncRising: 
            case EncFalling: {
                break;
            }
            case PulseWidth: 
            case CtreMagEncoder_Relative: 
            case CtreMagEncoder_Absolute: {
                retval = CanTalonJNI.IsPulseWidthSensorPresent(this.m_handle) == 0 ? FeedbackDeviceStatus.FeedbackStatusNotPresent : FeedbackDeviceStatus.FeedbackStatusPresent;
            }
        }
        return retval;
    }

    public int getNumberOfQuadIdxRises() {
        return CanTalonJNI.GetEncIndexRiseEvents(this.m_handle);
    }

    public int getPinStateQuadA() {
        return CanTalonJNI.GetQuadApin(this.m_handle);
    }

    public int getPinStateQuadB() {
        return CanTalonJNI.GetQuadBpin(this.m_handle);
    }

    public int getPinStateQuadIdx() {
        return CanTalonJNI.GetQuadIdxpin(this.m_handle);
    }

    public void setAnalogPosition(int newPosition) {
        this.setParameter(CanTalonJNI.param_t.eAinPosition, newPosition);
    }

    public int getAnalogInPosition() {
        return CanTalonJNI.GetAnalogInWithOv(this.m_handle);
    }

    public int getAnalogInRaw() {
        return this.getAnalogInPosition() & 0x3FF;
    }

    public int getAnalogInVelocity() {
        return CanTalonJNI.GetAnalogInVel(this.m_handle);
    }

    public int getClosedLoopError() {
        return CanTalonJNI.GetCloseLoopErr(this.m_handle);
    }

    public void setAllowableClosedLoopErr(int allowableCloseLoopError) {
        if (this.m_profile == 0) {
            this.setParameter(CanTalonJNI.param_t.eProfileParamSlot0_AllowableClosedLoopErr, allowableCloseLoopError);
        } else {
            this.setParameter(CanTalonJNI.param_t.eProfileParamSlot1_AllowableClosedLoopErr, allowableCloseLoopError);
        }
    }

    public boolean isFwdLimitSwitchClosed() {
        return CanTalonJNI.GetLimitSwitchClosedFor(this.m_handle) == 0;
    }

    public boolean isRevLimitSwitchClosed() {
        return CanTalonJNI.GetLimitSwitchClosedRev(this.m_handle) == 0;
    }

    public boolean getBrakeEnableDuringNeutral() {
        return CanTalonJNI.GetBrakeIsEnabled(this.m_handle) != 0;
    }

    public void configEncoderCodesPerRev(int codesPerRev) {
        this.m_codesPerRev = codesPerRev;
        this.setParameter(CanTalonJNI.param_t.eNumberEncoderCPR, this.m_codesPerRev);
    }

    public void configPotentiometerTurns(int turns) {
        this.m_numPotTurns = turns;
        this.setParameter(CanTalonJNI.param_t.eNumberPotTurns, this.m_numPotTurns);
    }

    @Override
    public double getTemperature() {
        return CanTalonJNI.GetTemp(this.m_handle);
    }

    @Override
    public double getOutputCurrent() {
        return CanTalonJNI.GetCurrent(this.m_handle);
    }

    @Override
    public double getOutputVoltage() {
        return this.getBusVoltage() * (double)CanTalonJNI.GetAppliedThrottle(this.m_handle) / 1023.0;
    }

    @Override
    public double getBusVoltage() {
        return CanTalonJNI.GetBatteryV(this.m_handle);
    }

    @Override
    public double getPosition() {
        return this.ScaleNativeUnitsToRotations(this.m_feedbackDevice, CanTalonJNI.GetSensorPosition(this.m_handle));
    }

    public void setPosition(double pos) {
        int nativePos = this.ScaleRotationsToNativeUnits(this.m_feedbackDevice, pos);
        CanTalonJNI.SetSensorPosition(this.m_handle, nativePos);
    }

    @Override
    public double getSpeed() {
        return this.ScaleNativeUnitsToRpm(this.m_feedbackDevice, CanTalonJNI.GetSensorVelocity(this.m_handle));
    }

    @Override
    public TalonControlMode getControlMode() {
        return this.m_controlMode;
    }

    @Override
    public void setControlMode(int mode) {
        TalonControlMode tcm = TalonControlMode.valueOf(mode);
        if (tcm != null) {
            this.changeControlMode(tcm);
        }
    }

    private void applyControlMode(TalonControlMode controlMode) {
        this.m_controlMode = controlMode;
        if (controlMode == TalonControlMode.Disabled) {
            this.m_controlEnabled = false;
        }
        CanTalonJNI.SetModeSelect(this.m_handle, TalonControlMode.Disabled.value);
        UsageReporting.report(52, this.m_deviceNumber + 1, controlMode.value);
    }

    public void changeControlMode(TalonControlMode controlMode) {
        if (this.m_controlMode != controlMode) {
            this.applyControlMode(controlMode);
        }
    }

    public void setFeedbackDevice(FeedbackDevice device) {
        this.m_feedbackDevice = device;
        CanTalonJNI.SetFeedbackDeviceSelect(this.m_handle, device.value);
    }

    public void setStatusFrameRateMs(StatusFrameRate stateFrame, int periodMs) {
        CanTalonJNI.SetStatusFrameRate(this.m_handle, stateFrame.value, periodMs);
    }

    public void enableControl() {
        this.changeControlMode(this.m_controlMode);
        this.m_controlEnabled = true;
    }

    @Override
    public void enable() {
        this.enableControl();
    }

    public void disableControl() {
        CanTalonJNI.SetModeSelect(this.m_handle, TalonControlMode.Disabled.value);
        this.m_controlEnabled = false;
    }

    public boolean isControlEnabled() {
        return this.m_controlEnabled;
    }

    @Override
    public double getP() {
        if (this.m_profile == 0) {
            CanTalonJNI.RequestParam(this.m_handle, CanTalonJNI.param_t.eProfileParamSlot0_P.value);
        } else {
            CanTalonJNI.RequestParam(this.m_handle, CanTalonJNI.param_t.eProfileParamSlot1_P.value);
        }
        Timer.delay(kDelayForSolicitedSignals);
        return CanTalonJNI.GetPgain(this.m_handle, this.m_profile);
    }

    @Override
    public double getI() {
        if (this.m_profile == 0) {
            CanTalonJNI.RequestParam(this.m_handle, CanTalonJNI.param_t.eProfileParamSlot0_I.value);
        } else {
            CanTalonJNI.RequestParam(this.m_handle, CanTalonJNI.param_t.eProfileParamSlot1_I.value);
        }
        Timer.delay(kDelayForSolicitedSignals);
        return CanTalonJNI.GetIgain(this.m_handle, this.m_profile);
    }

    @Override
    public double getD() {
        if (this.m_profile == 0) {
            CanTalonJNI.RequestParam(this.m_handle, CanTalonJNI.param_t.eProfileParamSlot0_D.value);
        } else {
            CanTalonJNI.RequestParam(this.m_handle, CanTalonJNI.param_t.eProfileParamSlot1_D.value);
        }
        Timer.delay(kDelayForSolicitedSignals);
        return CanTalonJNI.GetDgain(this.m_handle, this.m_profile);
    }

    @Override
    public double getF() {
        if (this.m_profile == 0) {
            CanTalonJNI.RequestParam(this.m_handle, CanTalonJNI.param_t.eProfileParamSlot0_F.value);
        } else {
            CanTalonJNI.RequestParam(this.m_handle, CanTalonJNI.param_t.eProfileParamSlot1_F.value);
        }
        Timer.delay(kDelayForSolicitedSignals);
        return CanTalonJNI.GetFgain(this.m_handle, this.m_profile);
    }

    public double getIZone() {
        if (this.m_profile == 0) {
            CanTalonJNI.RequestParam(this.m_handle, CanTalonJNI.param_t.eProfileParamSlot0_IZone.value);
        } else {
            CanTalonJNI.RequestParam(this.m_handle, CanTalonJNI.param_t.eProfileParamSlot1_IZone.value);
        }
        Timer.delay(kDelayForSolicitedSignals);
        return CanTalonJNI.GetIzone(this.m_handle, this.m_profile);
    }

    public double getCloseLoopRampRate() {
        if (this.m_profile == 0) {
            CanTalonJNI.RequestParam(this.m_handle, CanTalonJNI.param_t.eProfileParamSlot0_CloseLoopRampRate.value);
        } else {
            CanTalonJNI.RequestParam(this.m_handle, CanTalonJNI.param_t.eProfileParamSlot1_CloseLoopRampRate.value);
        }
        Timer.delay(kDelayForSolicitedSignals);
        double throttlePerMs = CanTalonJNI.GetCloseLoopRampRate(this.m_handle, this.m_profile);
        return throttlePerMs / 1023.0 * 12.0 * 1000.0;
    }

    public long GetFirmwareVersion() {
        CanTalonJNI.RequestParam(this.m_handle, CanTalonJNI.param_t.eFirmVers.value);
        Timer.delay(kDelayForSolicitedSignals);
        return CanTalonJNI.GetParamResponseInt32(this.m_handle, CanTalonJNI.param_t.eFirmVers.value);
    }

    public long GetIaccum() {
        CanTalonJNI.RequestParam(this.m_handle, CanTalonJNI.param_t.ePidIaccum.value);
        Timer.delay(kDelayForSolicitedSignals);
        return CanTalonJNI.GetParamResponseInt32(this.m_handle, CanTalonJNI.param_t.ePidIaccum.value);
    }

    @Override
    public void setP(double p) {
        CanTalonJNI.SetPgain(this.m_handle, this.m_profile, p);
    }

    @Override
    public void setI(double i) {
        CanTalonJNI.SetIgain(this.m_handle, this.m_profile, i);
    }

    @Override
    public void setD(double d) {
        CanTalonJNI.SetDgain(this.m_handle, this.m_profile, d);
    }

    @Override
    public void setF(double f) {
        CanTalonJNI.SetFgain(this.m_handle, this.m_profile, f);
    }

    public void setIZone(int izone) {
        CanTalonJNI.SetIzone(this.m_handle, this.m_profile, izone);
    }

    public void setCloseLoopRampRate(double rampRate) {
        int rate = (int)(rampRate * 1023.0 / 12.0 / 1000.0);
        CanTalonJNI.SetCloseLoopRampRate(this.m_handle, this.m_profile, rate);
    }

    @Override
    public void setVoltageRampRate(double rampRate) {
        int rate = (int)(rampRate * 1023.0 / 12.0 / 100.0);
        CanTalonJNI.SetRampThrottle(this.m_handle, rate);
    }

    public void setVoltageCompensationRampRate(double rampRate) {
        CanTalonJNI.SetVoltageCompensationRate(this.m_handle, rampRate / 1000.0);
    }

    public void ClearIaccum() {
        CanTalonJNI.SetParam(this.m_handle, CanTalonJNI.param_t.ePidIaccum.value, 0.0);
    }

    public void setPID(double p, double i, double d, double f, int izone, double closeLoopRampRate, int profile) {
        if (profile != 0 && profile != 1) {
            throw new IllegalArgumentException("Talon PID profile must be 0 or 1.");
        }
        this.m_profile = profile;
        this.setProfile(profile);
        this.setP(p);
        this.setI(i);
        this.setD(d);
        this.setF(f);
        this.setIZone(izone);
        this.setCloseLoopRampRate(closeLoopRampRate);
    }

    @Override
    public void setPID(double p, double i, double d) {
        this.setPID(p, i, d, 0.0, 0, 0.0, this.m_profile);
    }

    @Override
    public double getSetpoint() {
        return this.m_setPoint;
    }

    public void setProfile(int profile) {
        if (profile != 0 && profile != 1) {
            throw new IllegalArgumentException("Talon PID profile must be 0 or 1.");
        }
        this.m_profile = profile;
        CanTalonJNI.SetProfileSlotSelect(this.m_handle, this.m_profile);
    }

    @Override
    @Deprecated
    public void stopMotor() {
        this.disableControl();
    }

    @Override
    public void disable() {
        this.disableControl();
    }

    public int getDeviceID() {
        return this.m_deviceNumber;
    }

    public void clearIAccum() {
        CanTalonJNI.SetParam(this.m_handle, CanTalonJNI.param_t.ePidIaccum.value, 0.0);
    }

    public void setForwardSoftLimit(double forwardLimit) {
        int nativeLimitPos = this.ScaleRotationsToNativeUnits(this.m_feedbackDevice, forwardLimit);
        CanTalonJNI.SetForwardSoftLimit(this.m_handle, nativeLimitPos);
    }

    public int getForwardSoftLimit() {
        return CanTalonJNI.GetForwardSoftLimit(this.m_handle);
    }

    public void enableForwardSoftLimit(boolean enable) {
        CanTalonJNI.SetForwardSoftEnable(this.m_handle, enable ? 1 : 0);
    }

    public boolean isForwardSoftLimitEnabled() {
        return CanTalonJNI.GetForwardSoftEnable(this.m_handle) != 0;
    }

    public void setReverseSoftLimit(double reverseLimit) {
        int nativeLimitPos = this.ScaleRotationsToNativeUnits(this.m_feedbackDevice, reverseLimit);
        CanTalonJNI.SetReverseSoftLimit(this.m_handle, nativeLimitPos);
    }

    public int getReverseSoftLimit() {
        return CanTalonJNI.GetReverseSoftLimit(this.m_handle);
    }

    public void enableReverseSoftLimit(boolean enable) {
        CanTalonJNI.SetReverseSoftEnable(this.m_handle, enable ? 1 : 0);
    }

    public boolean isReverseSoftLimitEnabled() {
        return CanTalonJNI.GetReverseSoftEnable(this.m_handle) != 0;
    }

    public void configMaxOutputVoltage(double voltage) {
        this.configPeakOutputVoltage(voltage, -voltage);
    }

    public void configPeakOutputVoltage(double forwardVoltage, double reverseVoltage) {
        if (forwardVoltage > 12.0) {
            forwardVoltage = 12.0;
        } else if (forwardVoltage < 0.0) {
            forwardVoltage = 0.0;
        }
        if (reverseVoltage > 0.0) {
            reverseVoltage = 0.0;
        } else if (reverseVoltage < -12.0) {
            reverseVoltage = -12.0;
        }
        this.setParameter(CanTalonJNI.param_t.ePeakPosOutput, 1023.0 * forwardVoltage / 12.0);
        this.setParameter(CanTalonJNI.param_t.ePeakNegOutput, 1023.0 * reverseVoltage / 12.0);
    }

    public void configNominalOutputVoltage(double forwardVoltage, double reverseVoltage) {
        if (forwardVoltage > 12.0) {
            forwardVoltage = 12.0;
        } else if (forwardVoltage < 0.0) {
            forwardVoltage = 0.0;
        }
        if (reverseVoltage > 0.0) {
            reverseVoltage = 0.0;
        } else if (reverseVoltage < -12.0) {
            reverseVoltage = -12.0;
        }
        this.setParameter(CanTalonJNI.param_t.eNominalPosOutput, 1023.0 * forwardVoltage / 12.0);
        this.setParameter(CanTalonJNI.param_t.eNominalNegOutput, 1023.0 * reverseVoltage / 12.0);
    }

    public void setParameter(CanTalonJNI.param_t paramEnum, double value) {
        CanTalonJNI.SetParam(this.m_handle, paramEnum.value, value);
    }

    public double getParameter(CanTalonJNI.param_t paramEnum) {
        CanTalonJNI.RequestParam(this.m_handle, paramEnum.value);
        Timer.delay(kDelayForSolicitedSignals);
        return CanTalonJNI.GetParamResponse(this.m_handle, paramEnum.value);
    }

    public void clearStickyFaults() {
        CanTalonJNI.ClearStickyFaults(this.m_handle);
    }

    public void enableLimitSwitch(boolean forward, boolean reverse) {
        int mask = 4 + (forward ? 1 : 0) * 2 + (reverse ? 1 : 0);
        CanTalonJNI.SetOverrideLimitSwitchEn(this.m_handle, mask);
    }

    public void ConfigFwdLimitSwitchNormallyOpen(boolean normallyOpen) {
        CanTalonJNI.SetParam(this.m_handle, CanTalonJNI.param_t.eOnBoot_LimitSwitch_Forward_NormallyClosed.value, normallyOpen ? 0.0 : 1.0);
    }

    public void ConfigRevLimitSwitchNormallyOpen(boolean normallyOpen) {
        CanTalonJNI.SetParam(this.m_handle, CanTalonJNI.param_t.eOnBoot_LimitSwitch_Reverse_NormallyClosed.value, normallyOpen ? 0.0 : 1.0);
    }

    public void enableBrakeMode(boolean brake) {
        CanTalonJNI.SetOverrideBrakeType(this.m_handle, brake ? 2 : 1);
    }

    public int getFaultOverTemp() {
        return CanTalonJNI.GetFault_OverTemp(this.m_handle);
    }

    public int getFaultUnderVoltage() {
        return CanTalonJNI.GetFault_UnderVoltage(this.m_handle);
    }

    public int getFaultForLim() {
        return CanTalonJNI.GetFault_ForLim(this.m_handle);
    }

    public int getFaultRevLim() {
        return CanTalonJNI.GetFault_RevLim(this.m_handle);
    }

    public int getFaultHardwareFailure() {
        return CanTalonJNI.GetFault_HardwareFailure(this.m_handle);
    }

    public int getFaultForSoftLim() {
        return CanTalonJNI.GetFault_ForSoftLim(this.m_handle);
    }

    public int getFaultRevSoftLim() {
        return CanTalonJNI.GetFault_RevSoftLim(this.m_handle);
    }

    public int getStickyFaultOverTemp() {
        return CanTalonJNI.GetStckyFault_OverTemp(this.m_handle);
    }

    public int getStickyFaultUnderVoltage() {
        return CanTalonJNI.GetStckyFault_UnderVoltage(this.m_handle);
    }

    public int getStickyFaultForLim() {
        return CanTalonJNI.GetStckyFault_ForLim(this.m_handle);
    }

    public int getStickyFaultRevLim() {
        return CanTalonJNI.GetStckyFault_RevLim(this.m_handle);
    }

    public int getStickyFaultForSoftLim() {
        return CanTalonJNI.GetStckyFault_ForSoftLim(this.m_handle);
    }

    public int getStickyFaultRevSoftLim() {
        return CanTalonJNI.GetStckyFault_RevSoftLim(this.m_handle);
    }

    double GetNativeUnitsPerRotationScalar(FeedbackDevice devToLookup) {
        double retval = 0.0;
        boolean scalingAvail = false;
        switch (devToLookup) {
            case QuadEncoder: {
                int qeiPulsePerCount = 4;
                switch (this.m_feedbackDevice) {
                    case CtreMagEncoder_Relative: 
                    case CtreMagEncoder_Absolute: {
                        retval = 4096.0;
                        scalingAvail = true;
                        break;
                    }
                    case EncRising: 
                    case EncFalling: {
                        qeiPulsePerCount = 1;
                        break;
                    }
                }
                if (scalingAvail || 0 == this.m_codesPerRev) break;
                retval = 4 * this.m_codesPerRev;
                scalingAvail = true;
                break;
            }
            case EncRising: 
            case EncFalling: {
                if (0 == this.m_codesPerRev) break;
                retval = 1 * this.m_codesPerRev;
                scalingAvail = true;
                break;
            }
            case AnalogPot: 
            case AnalogEncoder: {
                if (0 == this.m_numPotTurns) break;
                retval = 1024.0 / (double)this.m_numPotTurns;
                scalingAvail = true;
                break;
            }
            case PulseWidth: 
            case CtreMagEncoder_Relative: 
            case CtreMagEncoder_Absolute: {
                retval = 4096.0;
                scalingAvail = true;
            }
        }
        if (!scalingAvail) {
            return 0.0;
        }
        return retval;
    }

    int ScaleRotationsToNativeUnits(FeedbackDevice devToLookup, double fullRotations) {
        int retval = (int)fullRotations;
        double scalar = this.GetNativeUnitsPerRotationScalar(devToLookup);
        if (scalar > 0.0) {
            retval = (int)(fullRotations * scalar);
        }
        return retval;
    }

    int ScaleVelocityToNativeUnits(FeedbackDevice devToLookup, double rpm) {
        int retval = (int)rpm;
        double scalar = this.GetNativeUnitsPerRotationScalar(devToLookup);
        if (scalar > 0.0) {
            retval = (int)(rpm * 0.0016666666666666668 * scalar);
        }
        return retval;
    }

    double ScaleNativeUnitsToRotations(FeedbackDevice devToLookup, int nativePos) {
        double retval = nativePos;
        double scalar = this.GetNativeUnitsPerRotationScalar(devToLookup);
        if (scalar > 0.0) {
            retval = (double)nativePos / scalar;
        }
        return retval;
    }

    double ScaleNativeUnitsToRpm(FeedbackDevice devToLookup, long nativeVel) {
        double retval = nativeVel;
        double scalar = this.GetNativeUnitsPerRotationScalar(devToLookup);
        if (scalar > 0.0) {
            retval = (double)nativeVel / (scalar * 0.0016666666666666668);
        }
        return retval;
    }

    public void enableZeroSensorPositionOnIndex(boolean enable, boolean risingEdge) {
        if (enable) {
            this.setParameter(CanTalonJNI.param_t.eQuadIdxPolarity, risingEdge ? 1.0 : 0.0);
            this.setParameter(CanTalonJNI.param_t.eClearPositionOnIdx, 1.0);
        } else {
            this.setParameter(CanTalonJNI.param_t.eClearPositionOnIdx, 0.0);
            this.setParameter(CanTalonJNI.param_t.eQuadIdxPolarity, risingEdge ? 1.0 : 0.0);
        }
    }

    public void changeMotionControlFramePeriod(int periodMs) {
        CanTalonJNI.ChangeMotionControlFramePeriod(this.m_handle, periodMs);
    }

    public void clearMotionProfileTrajectories() {
        CanTalonJNI.ClearMotionProfileTrajectories(this.m_handle);
    }

    public int getMotionProfileTopLevelBufferCount() {
        return CanTalonJNI.GetMotionProfileTopLevelBufferCount(this.m_handle);
    }

    public boolean pushMotionProfileTrajectory(TrajectoryPoint trajPt) {
        if (this.isMotionProfileTopLevelBufferFull()) {
            return false;
        }
        int targPos = this.ScaleRotationsToNativeUnits(this.m_feedbackDevice, trajPt.position);
        int targVel = this.ScaleVelocityToNativeUnits(this.m_feedbackDevice, trajPt.velocity);
        int profileSlotSelect = trajPt.profileSlotSelect > 0 ? 1 : 0;
        int timeDurMs = trajPt.timeDurMs;
        if (timeDurMs > 255) {
            timeDurMs = 255;
        }
        if (timeDurMs < 0) {
            timeDurMs = 0;
        }
        CanTalonJNI.PushMotionProfileTrajectory(this.m_handle, targPos, targVel, profileSlotSelect, timeDurMs, trajPt.velocityOnly ? 1 : 0, trajPt.isLastPoint ? 1 : 0, trajPt.zeroPos ? 1 : 0);
        return true;
    }

    public boolean isMotionProfileTopLevelBufferFull() {
        return CanTalonJNI.IsMotionProfileTopLevelBufferFull(this.m_handle);
    }

    public void processMotionProfileBuffer() {
        CanTalonJNI.ProcessMotionProfileBuffer(this.m_handle);
    }

    public void getMotionProfileStatus(MotionProfileStatus motionProfileStatus) {
        CanTalonJNI.GetMotionProfileStatus(this.m_handle, this, motionProfileStatus);
    }

    protected void setMotionProfileStatusFromJNI(MotionProfileStatus motionProfileStatus, int flags, int profileSlotSelect, int targPos, int targVel, int topBufferRem, int topBufferCnt, int btmBufferCnt, int outputEnable) {
        motionProfileStatus.topBufferRem = topBufferRem;
        motionProfileStatus.topBufferCnt = topBufferCnt;
        motionProfileStatus.btmBufferCnt = btmBufferCnt;
        motionProfileStatus.hasUnderrun = (flags & 2) > 0;
        motionProfileStatus.isUnderrun = (flags & 4) > 0;
        motionProfileStatus.activePointValid = (flags & 1) > 0;
        motionProfileStatus.activePoint.isLastPoint = (flags & 8) > 0;
        motionProfileStatus.activePoint.velocityOnly = (flags & 0x10) > 0;
        motionProfileStatus.activePoint.position = this.ScaleNativeUnitsToRotations(this.m_feedbackDevice, targPos);
        motionProfileStatus.activePoint.velocity = this.ScaleNativeUnitsToRpm(this.m_feedbackDevice, targVel);
        motionProfileStatus.activePoint.profileSlotSelect = profileSlotSelect;
        motionProfileStatus.outputEnable = SetValueMotionProfile.valueOf(outputEnable);
        motionProfileStatus.activePoint.zeroPos = false;
        motionProfileStatus.activePoint.timeDurMs = 0;
    }

    public void clearMotionProfileHasUnderrun() {
        this.setParameter(CanTalonJNI.param_t.eMotionProfileHasUnderrunErr, 0.0);
    }

    @Override
    public void setExpiration(double timeout) {
        this.m_safetyHelper.setExpiration(timeout);
    }

    @Override
    public double getExpiration() {
        return this.m_safetyHelper.getExpiration();
    }

    @Override
    public boolean isAlive() {
        return this.m_safetyHelper.isAlive();
    }

    @Override
    public boolean isSafetyEnabled() {
        return this.m_safetyHelper.isSafetyEnabled();
    }

    @Override
    public void setSafetyEnabled(boolean enabled) {
        this.m_safetyHelper.setSafetyEnabled(enabled);
    }

    @Override
    public String getDescription() {
        return "CANTalon ID " + this.m_deviceNumber;
    }

    @Override
    public void initTable(ITable subtable) {
        this.m_table = subtable;
        this.updateTable();
    }

    @Override
    public void updateTable() {
        CANSpeedController.super.updateTable();
    }

    @Override
    public ITable getTable() {
        return this.m_table;
    }

    @Override
    public void startLiveWindowMode() {
        this.set(0.0);
        this.m_table_listener = this.createTableListener();
        this.m_table.addTableListener(this.m_table_listener, true);
    }

    @Override
    public void stopLiveWindowMode() {
        this.set(0.0);
        this.m_table.removeTableListener(this.m_table_listener);
    }

    public static class MotionProfileStatus {
        public int topBufferRem;
        public int topBufferCnt;
        public int btmBufferCnt;
        public boolean hasUnderrun;
        public boolean isUnderrun;
        public boolean activePointValid;
        public TrajectoryPoint activePoint = new TrajectoryPoint();
        public SetValueMotionProfile outputEnable;
    }

    public static class TrajectoryPoint {
        public double position;
        public double velocity;
        public int timeDurMs;
        public int profileSlotSelect;
        public boolean velocityOnly;
        public boolean isLastPoint;
        public boolean zeroPos;
    }

    public static enum SetValueMotionProfile {
        Disable(0),
        Enable(1),
        Hold(2);

        public int value;

        public static SetValueMotionProfile valueOf(int value) {
            for (SetValueMotionProfile mode : SetValueMotionProfile.values()) {
                if (mode.value != value) continue;
                return mode;
            }
            return null;
        }

        private SetValueMotionProfile(int value) {
            this.value = value;
        }
    }

    public static enum StatusFrameRate {
        General(0),
        Feedback(1),
        QuadEncoder(2),
        AnalogTempVbat(3),
        PulseWidth(4);

        public int value;

        public static StatusFrameRate valueOf(int value) {
            for (StatusFrameRate mode : StatusFrameRate.values()) {
                if (mode.value != value) continue;
                return mode;
            }
            return null;
        }

        private StatusFrameRate(int value) {
            this.value = value;
        }
    }

    public static enum FeedbackDeviceStatus {
        FeedbackStatusUnknown(0),
        FeedbackStatusPresent(1),
        FeedbackStatusNotPresent(2);

        public int value;

        public static FeedbackDeviceStatus valueOf(int value) {
            for (FeedbackDeviceStatus mode : FeedbackDeviceStatus.values()) {
                if (mode.value != value) continue;
                return mode;
            }
            return null;
        }

        private FeedbackDeviceStatus(int value) {
            this.value = value;
        }
    }

    public static enum FeedbackDevice {
        QuadEncoder(0),
        AnalogPot(2),
        AnalogEncoder(3),
        EncRising(4),
        EncFalling(5),
        CtreMagEncoder_Relative(6),
        CtreMagEncoder_Absolute(7),
        PulseWidth(8);

        public int value;

        public static FeedbackDevice valueOf(int value) {
            for (FeedbackDevice mode : FeedbackDevice.values()) {
                if (mode.value != value) continue;
                return mode;
            }
            return null;
        }

        private FeedbackDevice(int value) {
            this.value = value;
        }
    }

    public static enum TalonControlMode implements CANSpeedController.ControlMode
    {
        PercentVbus(0),
        Position(1),
        Speed(2),
        Current(3),
        Voltage(4),
        Follower(5),
        MotionProfile(6),
        Disabled(15);

        public final int value;

        public static TalonControlMode valueOf(int value) {
            for (TalonControlMode mode : TalonControlMode.values()) {
                if (mode.value != value) continue;
                return mode;
            }
            return null;
        }

        private TalonControlMode(int value) {
            this.value = value;
        }

        @Override
        public boolean isPID() {
            return this == Current || this == Speed || this == Position;
        }

        @Override
        public int getValue() {
            return this.value;
        }
    }
}

