/*
 * Decompiled with CFR 0.152.
 */
package edu.wpi.first.wpilibj;

import edu.wpi.first.wpilibj.AnalogInput;
import edu.wpi.first.wpilibj.AnalogTriggerOutput;
import edu.wpi.first.wpilibj.communication.UsageReporting;
import edu.wpi.first.wpilibj.hal.AnalogJNI;
import edu.wpi.first.wpilibj.util.BoundaryException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;

public class AnalogTrigger {
    protected long m_port;
    protected int m_index;

    protected void initTrigger(int channel) {
        long port_pointer = AnalogJNI.getPort((byte)channel);
        ByteBuffer index = ByteBuffer.allocateDirect(4);
        index.order(ByteOrder.LITTLE_ENDIAN);
        this.m_port = AnalogJNI.initializeAnalogTrigger(port_pointer, index.asIntBuffer());
        this.m_index = index.asIntBuffer().get(0);
        UsageReporting.report(7, channel);
    }

    public AnalogTrigger(int channel) {
        this.initTrigger(channel);
    }

    public AnalogTrigger(AnalogInput channel) {
        if (channel == null) {
            throw new NullPointerException("The Analog Input given was null");
        }
        this.initTrigger(channel.getChannel());
    }

    public void free() {
        AnalogJNI.cleanAnalogTrigger(this.m_port);
        this.m_port = 0L;
    }

    public void setLimitsRaw(int lower, int upper) {
        if (lower > upper) {
            throw new BoundaryException("Lower bound is greater than upper");
        }
        AnalogJNI.setAnalogTriggerLimitsRaw(this.m_port, lower, upper);
    }

    public void setLimitsVoltage(double lower, double upper) {
        if (lower > upper) {
            throw new BoundaryException("Lower bound is greater than upper bound");
        }
        AnalogJNI.setAnalogTriggerLimitsVoltage(this.m_port, lower, upper);
    }

    public void setAveraged(boolean useAveragedValue) {
        AnalogJNI.setAnalogTriggerAveraged(this.m_port, useAveragedValue);
    }

    public void setFiltered(boolean useFilteredValue) {
        AnalogJNI.setAnalogTriggerFiltered(this.m_port, useFilteredValue);
    }

    public int getIndex() {
        return this.m_index;
    }

    public boolean getInWindow() {
        return AnalogJNI.getAnalogTriggerInWindow(this.m_port);
    }

    public boolean getTriggerState() {
        return AnalogJNI.getAnalogTriggerTriggerState(this.m_port);
    }

    public AnalogTriggerOutput createOutput(AnalogTriggerOutput.AnalogTriggerType type) {
        return new AnalogTriggerOutput(this, type);
    }

    public class AnalogTriggerException
    extends RuntimeException {
        public AnalogTriggerException(String message) {
            super(message);
        }
    }
}

