/*
 * Decompiled with CFR 0.152.
 */
package edu.wpi.first.wpilibj;

import edu.wpi.first.wpilibj.Resource;
import edu.wpi.first.wpilibj.SensorBase;
import edu.wpi.first.wpilibj.communication.UsageReporting;
import edu.wpi.first.wpilibj.hal.AnalogJNI;
import edu.wpi.first.wpilibj.livewindow.LiveWindow;
import edu.wpi.first.wpilibj.livewindow.LiveWindowSendable;
import edu.wpi.first.wpilibj.tables.ITable;
import edu.wpi.first.wpilibj.util.AllocationException;
import edu.wpi.first.wpilibj.util.CheckedAllocationException;

public class AnalogOutput
extends SensorBase
implements LiveWindowSendable {
    private static Resource channels = new Resource(2);
    private long m_port;
    private int m_channel;
    private ITable m_table;

    public AnalogOutput(int channel) {
        this.m_channel = channel;
        if (!AnalogJNI.checkAnalogOutputChannel(channel)) {
            throw new AllocationException("Analog output channel " + this.m_channel + " cannot be allocated. Channel is not present.");
        }
        try {
            channels.allocate(channel);
        }
        catch (CheckedAllocationException e) {
            throw new AllocationException("Analog output channel " + this.m_channel + " is already allocated");
        }
        long port_pointer = AnalogJNI.getPort((byte)channel);
        this.m_port = AnalogJNI.initializeAnalogOutputPort(port_pointer);
        LiveWindow.addSensor("AnalogOutput", channel, (LiveWindowSendable)this);
        UsageReporting.report(49, channel);
    }

    @Override
    public void free() {
        AnalogJNI.freeAnalogOutputPort(this.m_port);
        this.m_port = 0L;
        channels.free(this.m_channel);
        this.m_channel = 0;
    }

    public void setVoltage(double voltage) {
        AnalogJNI.setAnalogOutput(this.m_port, voltage);
    }

    public double getVoltage() {
        return AnalogJNI.getAnalogOutput(this.m_port);
    }

    @Override
    public String getSmartDashboardType() {
        return "Analog Output";
    }

    @Override
    public void initTable(ITable subtable) {
        this.m_table = subtable;
        this.updateTable();
    }

    @Override
    public void updateTable() {
        if (this.m_table != null) {
            this.m_table.putNumber("Value", this.getVoltage());
        }
    }

    @Override
    public ITable getTable() {
        return this.m_table;
    }

    @Override
    public void startLiveWindowMode() {
    }

    @Override
    public void stopLiveWindowMode() {
    }
}

