/*
 * Decompiled with CFR 0.152.
 */
package edu.wpi.first.wpilibj;

import edu.wpi.first.wpilibj.AccumulatorResult;
import edu.wpi.first.wpilibj.PIDSource;
import edu.wpi.first.wpilibj.PIDSourceType;
import edu.wpi.first.wpilibj.Resource;
import edu.wpi.first.wpilibj.SensorBase;
import edu.wpi.first.wpilibj.Timer;
import edu.wpi.first.wpilibj.communication.UsageReporting;
import edu.wpi.first.wpilibj.hal.AnalogJNI;
import edu.wpi.first.wpilibj.livewindow.LiveWindow;
import edu.wpi.first.wpilibj.livewindow.LiveWindowSendable;
import edu.wpi.first.wpilibj.tables.ITable;
import edu.wpi.first.wpilibj.util.AllocationException;
import edu.wpi.first.wpilibj.util.CheckedAllocationException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;

public class AnalogInput
extends SensorBase
implements PIDSource,
LiveWindowSendable {
    private static final int kAccumulatorSlot = 1;
    private static Resource channels = new Resource(8);
    private long m_port;
    private int m_channel;
    private static final int[] kAccumulatorChannels = new int[]{0, 1};
    private long m_accumulatorOffset;
    protected PIDSourceType m_pidSource = PIDSourceType.kDisplacement;
    private ITable m_table;

    public AnalogInput(int channel) {
        this.m_channel = channel;
        if (!AnalogJNI.checkAnalogInputChannel(channel)) {
            throw new AllocationException("Analog input channel " + this.m_channel + " cannot be allocated. Channel is not present.");
        }
        try {
            channels.allocate(channel);
        }
        catch (CheckedAllocationException e) {
            throw new AllocationException("Analog input channel " + this.m_channel + " is already allocated");
        }
        long port_pointer = AnalogJNI.getPort((byte)channel);
        this.m_port = AnalogJNI.initializeAnalogInputPort(port_pointer);
        LiveWindow.addSensor("AnalogInput", channel, (LiveWindowSendable)this);
        UsageReporting.report(6, channel);
    }

    @Override
    public void free() {
        AnalogJNI.freeAnalogInputPort(this.m_port);
        this.m_port = 0L;
        channels.free(this.m_channel);
        this.m_channel = 0;
        this.m_accumulatorOffset = 0L;
    }

    public int getValue() {
        return AnalogJNI.getAnalogValue(this.m_port);
    }

    public int getAverageValue() {
        return AnalogJNI.getAnalogAverageValue(this.m_port);
    }

    public double getVoltage() {
        return AnalogJNI.getAnalogVoltage(this.m_port);
    }

    public double getAverageVoltage() {
        return AnalogJNI.getAnalogAverageVoltage(this.m_port);
    }

    public long getLSBWeight() {
        return AnalogJNI.getAnalogLSBWeight(this.m_port);
    }

    public int getOffset() {
        return AnalogJNI.getAnalogOffset(this.m_port);
    }

    public int getChannel() {
        return this.m_channel;
    }

    public void setAverageBits(int bits) {
        AnalogJNI.setAnalogAverageBits(this.m_port, bits);
    }

    public int getAverageBits() {
        return AnalogJNI.getAnalogAverageBits(this.m_port);
    }

    public void setOversampleBits(int bits) {
        AnalogJNI.setAnalogOversampleBits(this.m_port, bits);
    }

    public int getOversampleBits() {
        return AnalogJNI.getAnalogOversampleBits(this.m_port);
    }

    public void initAccumulator() {
        if (!this.isAccumulatorChannel()) {
            throw new AllocationException("Accumulators are only available on slot 1 on channels " + kAccumulatorChannels[0] + ", " + kAccumulatorChannels[1]);
        }
        this.m_accumulatorOffset = 0L;
        AnalogJNI.initAccumulator(this.m_port);
    }

    public void setAccumulatorInitialValue(long initialValue) {
        this.m_accumulatorOffset = initialValue;
    }

    public void resetAccumulator() {
        AnalogJNI.resetAccumulator(this.m_port);
        double sampleTime = 1.0 / AnalogInput.getGlobalSampleRate();
        double overSamples = 1 << this.getOversampleBits();
        double averageSamples = 1 << this.getAverageBits();
        Timer.delay(sampleTime * overSamples * averageSamples);
    }

    public void setAccumulatorCenter(int center) {
        AnalogJNI.setAccumulatorCenter(this.m_port, center);
    }

    public void setAccumulatorDeadband(int deadband) {
        AnalogJNI.setAccumulatorDeadband(this.m_port, deadband);
    }

    public long getAccumulatorValue() {
        return AnalogJNI.getAccumulatorValue(this.m_port) + this.m_accumulatorOffset;
    }

    public long getAccumulatorCount() {
        return AnalogJNI.getAccumulatorCount(this.m_port);
    }

    public void getAccumulatorOutput(AccumulatorResult result) {
        if (result == null) {
            throw new IllegalArgumentException("Null parameter `result'");
        }
        if (!this.isAccumulatorChannel()) {
            throw new IllegalArgumentException("Channel " + this.m_channel + " is not an accumulator channel.");
        }
        ByteBuffer value = ByteBuffer.allocateDirect(8);
        value.order(ByteOrder.LITTLE_ENDIAN);
        ByteBuffer count = ByteBuffer.allocateDirect(4);
        count.order(ByteOrder.LITTLE_ENDIAN);
        AnalogJNI.getAccumulatorOutput(this.m_port, value.asLongBuffer(), count.asIntBuffer());
        result.value = value.asLongBuffer().get(0) + this.m_accumulatorOffset;
        result.count = count.asIntBuffer().get(0);
    }

    public boolean isAccumulatorChannel() {
        for (int i = 0; i < kAccumulatorChannels.length; ++i) {
            if (this.m_channel != kAccumulatorChannels[i]) continue;
            return true;
        }
        return false;
    }

    public static void setGlobalSampleRate(double samplesPerSecond) {
        AnalogJNI.setAnalogSampleRate((float)samplesPerSecond);
    }

    public static double getGlobalSampleRate() {
        return AnalogJNI.getAnalogSampleRate();
    }

    @Override
    public void setPIDSourceType(PIDSourceType pidSource) {
        this.m_pidSource = pidSource;
    }

    @Override
    public PIDSourceType getPIDSourceType() {
        return this.m_pidSource;
    }

    @Override
    public double pidGet() {
        return this.getAverageVoltage();
    }

    @Override
    public String getSmartDashboardType() {
        return "Analog Input";
    }

    @Override
    public void initTable(ITable subtable) {
        this.m_table = subtable;
        this.updateTable();
    }

    @Override
    public void updateTable() {
        if (this.m_table != null) {
            this.m_table.putNumber("Value", this.getAverageVoltage());
        }
    }

    @Override
    public ITable getTable() {
        return this.m_table;
    }

    @Override
    public void startLiveWindowMode() {
    }

    @Override
    public void stopLiveWindowMode() {
    }
}

