/*
 * Decompiled with CFR 0.152.
 */
package edu.wpi.first.wpilibj;

import edu.wpi.first.wpilibj.AnalogInput;
import edu.wpi.first.wpilibj.PIDSource;
import edu.wpi.first.wpilibj.PIDSourceType;
import edu.wpi.first.wpilibj.SensorBase;
import edu.wpi.first.wpilibj.communication.UsageReporting;
import edu.wpi.first.wpilibj.livewindow.LiveWindow;
import edu.wpi.first.wpilibj.livewindow.LiveWindowSendable;
import edu.wpi.first.wpilibj.tables.ITable;

public class AnalogAccelerometer
extends SensorBase
implements PIDSource,
LiveWindowSendable {
    private AnalogInput m_analogChannel;
    private double m_voltsPerG = 1.0;
    private double m_zeroGVoltage = 2.5;
    private boolean m_allocatedChannel;
    protected PIDSourceType m_pidSource = PIDSourceType.kDisplacement;
    private ITable m_table;

    private void initAccelerometer() {
        UsageReporting.report(4, this.m_analogChannel.getChannel());
        LiveWindow.addSensor("Accelerometer", this.m_analogChannel.getChannel(), (LiveWindowSendable)this);
    }

    public AnalogAccelerometer(int channel) {
        this.m_allocatedChannel = true;
        this.m_analogChannel = new AnalogInput(channel);
        this.initAccelerometer();
    }

    public AnalogAccelerometer(AnalogInput channel) {
        this.m_allocatedChannel = false;
        if (channel == null) {
            throw new NullPointerException("Analog Channel given was null");
        }
        this.m_analogChannel = channel;
        this.initAccelerometer();
    }

    @Override
    public void free() {
        if (this.m_analogChannel != null && this.m_allocatedChannel) {
            this.m_analogChannel.free();
        }
        this.m_analogChannel = null;
    }

    public double getAcceleration() {
        return (this.m_analogChannel.getAverageVoltage() - this.m_zeroGVoltage) / this.m_voltsPerG;
    }

    public void setSensitivity(double sensitivity) {
        this.m_voltsPerG = sensitivity;
    }

    public void setZero(double zero) {
        this.m_zeroGVoltage = zero;
    }

    @Override
    public void setPIDSourceType(PIDSourceType pidSource) {
        this.m_pidSource = pidSource;
    }

    @Override
    public PIDSourceType getPIDSourceType() {
        return this.m_pidSource;
    }

    @Override
    public double pidGet() {
        return this.getAcceleration();
    }

    @Override
    public String getSmartDashboardType() {
        return "Accelerometer";
    }

    @Override
    public void initTable(ITable subtable) {
        this.m_table = subtable;
        this.updateTable();
    }

    @Override
    public ITable getTable() {
        return this.m_table;
    }

    @Override
    public void updateTable() {
        if (this.m_table != null) {
            this.m_table.putNumber("Value", this.getAcceleration());
        }
    }

    @Override
    public void startLiveWindowMode() {
    }

    @Override
    public void stopLiveWindowMode() {
    }
}

